/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Color;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class EtchApplet
extends JApplet
implements KeyListener,
Runnable {
    JFrame frame;
    EtchEngine etch;
    JLabel element;
    JLabel pensize;
    JLabel gamespeed;
    JLabel about;
    JPanel screen;
    int pindex = 0;
    int sindex = 1;
    int eindex = 0;
    String penstr = "Pen Size: ";
    int[] pensizes = new int[]{2, 4, 8, 16, 32, 64};
    String spdstr = "Game speed: x";
    int[] gamespeeds;
    String[] resourcenames;
    boolean ml;
    boolean mr;
    boolean mu;
    boolean md;
    boolean el;
    boolean er;
    boolean pl;
    boolean pr;
    boolean sl;
    boolean sr;
    boolean dr;
    int SAND;
    int WATER;
    int FIRE;
    int WALL;
    int PLANT;
    int SPOUT;
    int TORCH;
    int WELL;
    int NITRO;
    int NAPA;
    int GUNP;
    int CONC;
    int C4;
    int ICE;
    int CERA;
    int CERA2;
    int OIL;
    int SALTWATER;
    int SALT;
    int METH;
    int BLANK;
    int FLASH;
    int ARBIT;
    int[] colors;

    public EtchApplet() {
        int[] arrn = new int[5];
        arrn[1] = 1;
        arrn[2] = 2;
        arrn[3] = 3;
        arrn[4] = 4;
        this.gamespeeds = arrn;
        this.resourcenames = new String[]{"WALL", "FIRE", "WATER", "PLANT", "SAND", "CERA", "OIL", "SALT", "SPOUT", "ERASER"};
        this.SAND = -1127296;
        this.WATER = -14671617;
        this.FIRE = -49088;
        this.WALL = -8355712;
        this.PLANT = -14627808;
        this.SPOUT = -9395969;
        this.TORCH = -701681;
        this.WELL = -12906480;
        this.NITRO = -13339130;
        this.NAPA = -1531362;
        this.GUNP = -6453650;
        this.CONC = -7626078;
        this.C4 = -331108;
        this.ICE = -4598273;
        this.CERA = -1122868;
        this.CERA2 = -1122867;
        this.OIL = -8372160;
        this.SALTWATER = -12549889;
        this.SALT = -1;
        this.METH = -16185079;
        this.BLANK = -16777216;
        this.FLASH = -1286;
        this.ARBIT = -8891442;
        this.colors = new int[]{this.WALL, this.FIRE, this.WATER, this.PLANT, this.SAND, this.CERA, this.OIL, this.SALT, this.SPOUT, this.BLANK};
    }

    public static void main(String[] crap) {
        EtchApplet ap = new EtchApplet();
        ap.initFrame();
    }

    public void initFrame() {
        this.frame = new JFrame("Etch-a-Sketch Sand");
        this.frame.setDefaultCloseOperation(3);
        this.frame.setLayout(null);
        this.frame.setSize(700, 700);
        this.resize(700, 700);
        this.setSize(700, 700);
        this.createGame();
        this.screen.setSize(700, 700);
        this.frame.add(this);
        this.frame.setVisible(true);
        this.start();
        this.screen.requestFocus();
    }

    public void init() {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    EtchApplet.this.createGame();
                }
            });
        }
        catch (Exception e) {
            System.err.println("createGUI didn't successfully complete");
        }
    }

    public void createGame() {
        this.addKeyListener(this);
        this.screen = new JPanel();
        this.screen.setLayout(null);
        this.screen.setOpaque(false);
        System.out.println(System.getProperty("java.version"));
        this.screen.addKeyListener(this);
        this.screen.setFocusable(true);
        this.element = new JLabel(this.resourcenames[this.eindex]);
        this.element.setForeground(Color.BLUE);
        this.element.setSize(100, 15);
        this.element.setLocation(0, 0);
        this.element.addKeyListener(this);
        this.screen.add(this.element);
        this.pensize = new JLabel(String.valueOf(String.valueOf(this.penstr)) + this.pensizes[this.pindex]);
        this.pensize.setForeground(Color.BLUE);
        this.pensize.setSize(100, 15);
        this.pensize.setLocation(0, 15);
        this.pensize.addKeyListener(this);
        this.screen.add(this.pensize);
        this.gamespeed = new JLabel(String.valueOf(String.valueOf(this.spdstr)) + this.gamespeeds[this.sindex]);
        this.gamespeed.setForeground(Color.BLUE);
        this.gamespeed.setSize(100, 15);
        this.gamespeed.setLocation(0, 30);
        this.gamespeed.addKeyListener(this);
        this.screen.add(this.gamespeed);
        this.about = new JLabel();
        this.about.setForeground(Color.white);
        this.about.setSize(400, 400);
        this.about.setLocation(50, 50);
        this.about.addKeyListener(this);
        this.screen.add(this.about);
        this.about.setText("<html>Etch-a-Sketch Sand.<br>Developed by XavierSoft<br>Application Adaptation by Androdome<br><br>Directions<br>Use the arrow keys to move the cursor<br>Press the space bar to draw<br>Use keys Q and W to select Elements<br>Use keys A and S to set pen size<br>Use keys Z and X to set game speed<br>Display help by pressing the H key <br><br>Sorry for the rather crude application adaptation, I know there are bugs, I barely got it to work in the first place.</html>");
        this.setContentPane(this.screen);
    }

    public void updateLabels() {
        boolean ch = false;
        if (this.el) {
            ch = true;
            --this.eindex;
            if (this.eindex < 0) {
                this.eindex = this.resourcenames.length - 1;
            }
        }
        if (this.er) {
            ch = true;
            this.eindex = (this.eindex + 1) % this.resourcenames.length;
        }
        if (this.pl) {
            ch = true;
            --this.pindex;
            if (this.pindex < 0) {
                this.pindex = this.pensizes.length - 1;
            }
        }
        if (this.pr) {
            ch = true;
            this.pindex = (this.pindex + 1) % this.pensizes.length;
        }
        if (this.sl) {
            ch = true;
            --this.sindex;
            if (this.sindex < 0) {
                this.sindex = this.gamespeeds.length - 1;
            }
        }
        if (this.sr) {
            ch = true;
            this.sindex = (this.sindex + 1) % this.gamespeeds.length;
        }
        if (ch) {
            this.etch.lastdisp = System.currentTimeMillis();
            this.sr = false;
            this.sl = false;
            this.pr = false;
            this.pl = false;
            this.er = false;
            this.el = false;
            this.element.setText(this.resourcenames[this.eindex]);
            this.pensize.setText(String.valueOf(String.valueOf(this.penstr)) + this.pensizes[this.pindex]);
            this.gamespeed.setText(String.valueOf(String.valueOf(this.spdstr)) + this.gamespeeds[this.sindex]);
            this.etch.setSpeed(this.gamespeeds[this.sindex]);
        }
    }

    public void run() {
        this.etch = new EtchEngine(this);
        this.screen.requestFocus();
        this.etch.helpdisp = System.currentTimeMillis();
        this.etch.run();
    }

    public void start() {
        Thread t = new Thread(this);
        t.start();
    }

    public void stop() {
    }

    public void keyPressed(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                this.ml = true;
                break;
            }
            case 39: {
                this.mr = true;
                break;
            }
            case 38: {
                this.mu = true;
                break;
            }
            case 40: {
                this.md = true;
                break;
            }
            case 81: {
                this.el = true;
                break;
            }
            case 87: {
                this.er = true;
                break;
            }
            case 65: {
                this.pl = true;
                break;
            }
            case 83: {
                this.pr = true;
                break;
            }
            case 90: {
                this.sl = true;
                break;
            }
            case 88: {
                this.sr = true;
                break;
            }
            case 32: {
                this.dr = true;
                break;
            }
            case 72: {
                this.etch.helpdisp = System.currentTimeMillis() + 2000L;
            }
        }
    }

    public void keyReleased(KeyEvent e) {
        switch (e.getKeyCode()) {
            case 37: {
                this.ml = false;
                break;
            }
            case 39: {
                this.mr = false;
                break;
            }
            case 38: {
                this.mu = false;
                break;
            }
            case 40: {
                this.md = false;
                break;
            }
            case 81: {
                this.el = false;
                break;
            }
            case 87: {
                this.er = false;
                break;
            }
            case 65: {
                this.pl = false;
                break;
            }
            case 83: {
                this.pr = false;
                break;
            }
            case 90: {
                this.sl = false;
                break;
            }
            case 88: {
                this.sr = false;
                break;
            }
            case 32: {
                this.dr = false;
            }
        }
    }

    public void keyTyped(KeyEvent e) {
    }
}

